import { NextRequest, NextResponse } from 'next/server';
import { testimonialStore } from '@/lib/data-store';

export async function GET() {
  try {
    const testimonials = await testimonialStore.getAll();
    return NextResponse.json({ success: true, data: testimonials });
  } catch (error) {
    return NextResponse.json({ success: false, error: 'Failed to fetch testimonials' }, { status: 500 });
  }
}

export async function POST(request: NextRequest) {
  try {
    const data = await request.json();
    const testimonial = await testimonialStore.create(data);
    return NextResponse.json({ success: true, data: testimonial });
  } catch (error) {
    return NextResponse.json({ success: false, error: 'Failed to create testimonial' }, { status: 500 });
  }
}